#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29887);
 script_cve_id("CVE-2007-2865");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: phpPgAdmin security update (phpPgAdmin-4713)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch phpPgAdmin-4713.

Description :

Several flaws in phpPgAdmin could be exploited by remote
attackers to perform cross site scripting (XSS) attacks
(CVE-2007-2865, CVE-2007-5728).


Solution : 

Install the security patch phpPgAdmin-4713.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the phpPgAdmin-4713 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"phpPgAdmin-4.0.1-61.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
