#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27409);
 
 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: This update fixes a possible SSL man-in-the-middle attack (python-wbem-2692)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch python-wbem-2692.

Description :

This update switches the usage from python's SSL class to
python-openssl. The original python class does not verify
the SSL certificates which makes python-wbem vulnerable to
a man-in-the-middle attack.


Solution : 

Install the security patch python-wbem-2692.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the python-wbem-2692 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"python-wbem-0.4.cvs20060406-7.3", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
