#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29564);
 script_cve_id("CVE-2007-0242");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for Qt3 (qt3-3052)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch qt3-3052.

Description :

qt wrongly accepts overly long UTF-8 sequences due to a bug
in the UTF-8 decoder. This may lead to security problems
unter certain circumstances. The bug for example allows for
script tag injection in konqueror (CVE-2007-0242).


Solution : 

Install the security patch qt3-3052.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the qt3-3052 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"qt3-3.3.5-58.15.3", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"qt3-devel-3.3.5-58.15.3", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"qt3-3.3.5-58.15.3", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"qt3-devel-3.3.5-58.15.3", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
