#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29565);
 script_cve_id("CVE-2007-3388");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for Qt3 (qt3-3898)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch qt3-3898.

Description :

Format string bugs in QTextEdit can be exploited via
specially crafted HTML tags to potentially execute code
(CVE-2007-3388).


Solution : 

Install the security patch qt3-3898.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the qt3-3898 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"qt3-3.3.5-58.29", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"qt3-devel-3.3.5-58.29", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"qt3-3.3.5-58.29", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"qt3-devel-3.3.5-58.29", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
