#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27416);
 script_cve_id("CVE-2006-2223");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: quagga security update (quagga-1422)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch quagga-1422.

Description :

It was possible to bypass RIPv2 authentication requirements
by using RIPv1. Since RIPv1 doesn't support authentication
at all this update introduces an option to switch off RIPv1
(CVE-2006-2223, CVE-2006-2224).


Solution : 

Install the security patch quagga-1422.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the quagga-1422 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"quagga-0.98.5-17.5", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
