#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27419);
 
 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: This update of rrdtoll fixes a minor denial-of-service problem. (rrdtool-2540)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch rrdtool-2540.

Description :

This update of rrdtool fixes a denial-of-service problem
that occurs when rrdgraph tries to graph data on a
logarithmic scale and the data processed is <= 0.


Solution : 

Install the security patch rrdtool-2540.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the rrdtool-2540 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"rrdtool-1.2.15-38.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
