#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27422);
 script_cve_id("CVE-2006-5467");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: ruby: Fixed denial of service problem in CGI multipart parsing (ruby-2219)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch ruby-2219.

Description :

A denial of service problem in the CGI multipart parsing of
'ruby' was fixed, which could have allowed remote attackers
to affect a denial of service attack against ruby based
webservices. (CVE-2006-5467)


Solution : 

Install the security patch ruby-2219.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the ruby-2219 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"ruby-1.8.4-17.8", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
