#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(28206);
 script_cve_id("CVE-2007-3227", "CVE-2007-5379");

 script_version ("$Revision: 1.2 $");

 name["english"] = "SuSE Security Update: rubygem-activesupport security update (rubygem-activesupport-4565)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch rubygem-activesupport-4565.

Description :

A cross site scripting (XSS) bug allowed attackers to
execute Javascript code in the context of other web sites
(CVE-2007-3227).

Specially crafted requests could crash an application when
processing XML data (CVE-2007-5379).


Solution : 

Install the security patch rubygem-activesupport-4565.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the rubygem-activesupport-4565 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"rubygem-activesupport-1.4.2-20.2", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
