#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27424);
 script_cve_id("CVE-2007-0469");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: This update of rubygems does not overwrite files during installation anymore (rubygems-2644)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch rubygems-2644.

Description :

This update fixes a vulnerability in rubygems that allowed
to overwrite files with root privileges. (CVE-2007-0469)


Solution : 

Install the security patch rubygems-2644.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the rubygems-2644 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"rubygems-0.9.2-4.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"rubygems-0.9.2-4.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
