#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27427);
 script_cve_id("CVE-2007-0452");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: samba: Fix logic error in the deferred open code and some other issues. (samba-2553)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch samba-2553.

Description :

A logic error in the deferred open code can lead to an
infinite loop in Samba's smbd daemon (CVE-2007-0452).

In addition the following changes are included with these
packages:

- Move tdb utils to the client package.
- Add version of the package subversion to Samba vendor
  version suffix.
- Fix time value reporting in libsmbclient; [#195285].
- Store and restore NT hashes as string compatible values;
  [#185053].
- Added winbindd null sid fix; [#185053].
- Fix from Alison Winters of SGI to build even if
  make_vscan is 0.
- Send correct workstation name to prevent
  NT_STATUS_INVALID_WORKSTATION beeing returned in
  samlogon; [#148645], [#161051].


Solution : 

Install the security patch samba-2553.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the samba-2553 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"samba-3.0.22-13.27", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"samba-32bit-3.0.22-13.27", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"samba-64bit-3.0.22-13.27", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"samba-client-3.0.22-13.27", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"samba-client-32bit-3.0.22-13.27", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"samba-client-64bit-3.0.22-13.27", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"samba-winbind-3.0.22-13.27", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"samba-winbind-32bit-3.0.22-13.27", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"samba-winbind-64bit-3.0.22-13.27", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
