#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27449);
 script_cve_id("CVE-2006-2447");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: spamassassin: Securityfix for potential remote root exploit. (spamassassin-1904)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch spamassassin-1904.

Description :

This update fixes the following security problem in
SpamAssassin:
- CVE-2006-2447: SpamAssassin when running with vpopmail
  and the paranoid (-P) switch, allows remote attackers to
  execute arbitrary commands via a crafted message that is
  not properly handled when invoking spamd with the virtual
  pop username.

At the same time we upgraded SpamAssassin to version 3.1.3,
bringing lots of bug fixes and new rules.

Please make sure you verify that it still works with your
configuration.

Also included is now 'sa-update', a rule update script. For
this script to work make sure that the perl-IO-ZLib and
perl-libwww-perl packages are installed.


Solution : 

Install the security patch spamassassin-1904.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the spamassassin-1904 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"perl-spamassassin-3.1.3-3.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"spamassassin-3.1.3-3.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
