#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29581);
 script_cve_id("CVE-2007-0451");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for SPAMAssassin (spamassassin-3078)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch spamassassin-3078.

Description :

This upgrade brings spamassassin to version 3.1.8 with
following changes:

* fix for CVE-2007-0451: possible DoS due to incredibly
  long URIs found in the message content.
* disable perl module usage in update channels unless
  --allowplugins is specified
* files with names starting/ending in whitespace weren't
  usable
* remove Text::Wrap related code due to upstream issues
* update spamassassin and sa-learn to better deal with STDIN
* improvements and bug fixes related to DomainKeys and DKIM
  support
* several updates for Received header parsing
* several documentation updates and random taint-variable
  related issues

This update also adds some missing dependencies.


Solution : 

Install the security patch spamassassin-3078.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the spamassassin-3078 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"perl-spamassassin-3.1.8-9.2", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"spamassassin-3.1.8-9.2", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"perl-spamassassin-3.1.8-9.2", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"spamassassin-3.1.8-9.2", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
