#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29823);
 script_cve_id("CVE-2007-6239");

 script_version ("$Revision: 1.2 $");

 name["english"] = "SuSE Security Update: squid: Fix possible remote denial-of-service. (squid-4779)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch squid-4779.

Description :

This update of squid fixes a denial-of-service bug during
cache update reply processing. (CVE-2007-6239)


Solution : 

Install the security patch squid-4779.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the squid-4779 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"squid-2.5.STABLE12-18.9", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"squid-2.6.STABLE6-0.8", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"squid-2.6.STABLE14-23.2", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
