#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29824);
 script_cve_id("CVE-2007-6239");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for squid (squid-4782)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch squid-4782.

Description :

This update of squid fixes a denial-of-service bug during
cache update reply processing. (CVE-2007-6239)


Solution : 

Install the security patch squid-4782.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the squid-4782 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"squid-2.5.STABLE12-18.9", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"squid-2.5.STABLE12-18.9", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
