#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27454);
 script_cve_id("CVE-2006-2842");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: squirrelmail: Security fix to protect against local file inclusion (squirrelmail-1837)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch squirrelmail-1837.

Description :

This update fixes a local file inclusion problem in the
squirrelmail webmail frontend. The issue is tracked by the
Mitre CVE ID CVE-2006-2842.


Solution : 

Install the security patch squirrelmail-1837.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the squirrelmail-1837 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"squirrelmail-1.4.5-18.2", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
