#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27459);
 script_cve_id("CVE-2007-4131");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: star: Fixed a directory traversal bug (CVE-2007-4131) (star-4173)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch star-4173.

Description :

This update fixes a directory traversal bug in star.
(CVE-2007-4131)


Solution : 

Install the security patch star-4173.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the star-4173 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"star-1.5a70-12.6", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"star-1.5a70-35", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
