#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27462);
 script_cve_id("CVE-2006-6097");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: tar: Securityupdate to fix symlink traversal (tar-2343)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch tar-2343.

Description :

This security update fixes a directory traversal in tar,
where unpacked symlinks could be followed outside of the
directory where the tar file is unpacked. (CVE-2006-6097)

This feature was made optional and needs to be enabled with
a commandline option.


Solution : 

Install the security patch tar-2343.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the tar-2343 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"tar-1.15.1-23.5", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
