#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27468);
 script_cve_id("CVE-2006-2656");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: Tiff security update (tiff-1594)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch tiff-1594.

Description :

This update fixes a stack-based buffer overflow in 
tiffsplit that can be triggered with long filemanes 
(CVE-2006-2656) and a buffer overflow in tiff2pdf. Both 
tools are not setuid but may be exploited in conjunction 
with other applications. Exploitation very unlikely.


Solution : 

Install the security patch tiff-1594.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the tiff-1594 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"tiff-3.8.2-5.6", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
