#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29590);
 script_cve_id("CVE-2007-5137");

 script_version ("$Revision: 1.3 $");

 name["english"] = "SuSE Security Update: Security update for Tk (tk-4478)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch tk-4478.

Description :

This update fixes a buffer overflow that occurs while
processing interlaced/animatedGIF images. (CVE-2007-4851)
This bug could be used to execute code remotely.


Solution : 

Install the security patch tk-4478.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the tk-4478 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"tk-8.4.12-14.9", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"tk-devel-8.4.12-14.9", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"tk-8.4.12-14.9", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
