#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(28287);
 script_cve_id("CVE-2005-4790");

 script_version ("$Revision: 1.2 $");

 name["english"] = "SuSE Security Update: tomboy security update (tomboy-4698)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch tomboy-4698.

Description :

The tomboy mediaplayer used LD_LIBRARY_PATH unsafely by
allowing empty LD_LIBRARY_PATH components.

This would enable the player to load its shared libraries
of the current directory which might contain user supplied
shared libraries, potentially supplied from the network by
an attacker. (CVE-2005-4790)


Solution : 

Install the security patch tomboy-4698.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the tomboy-4698 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"tomboy-0.8.0-9.2", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
