#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27474);
 script_cve_id("CVE-2007-2438");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: vim security update (vim-3410)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch vim-3410.

Description :

Files with VIM modelines could call some unsafe VIM
functions (CVE-2007-2438). Modelines are disabled in the
default config (/etc/vimrc) of openSUSE though.


Solution : 

Install the security patch vim-3410.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the vim-3410 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"gvim-7.0-36", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"vim-7.0-36", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"vim-enhanced-7.0-36", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
