#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29594);
 script_cve_id("CVE-2006-6772");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for w3m (w3m-2439)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch w3m-2439.

Description :

A format string problem in w3m -dump / -backend mode could
be used
 by a malicious server to crash w3m or execute
code. (CVE-2006-6772)


Solution : 

Install the security patch w3m-2439.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the w3m-2439 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"w3m-0.5.1-19.5", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"w3m-0.5.1-19.5", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
