#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27476);
 script_cve_id("CVE-2004-1488");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: wget: Security update solving terminal escape codes problems (wget-1689)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch wget-1689.

Description :

This update fixes a security in wget, where evil servers
could send terminal escape codes to the user calling wget.
This would only affect interactive sessions. (CVE-2004-1488)

Additionaly a previous '.file' fix was found to be buggy
and replaced. This bug could lead to '.directories' not
being retrievable and '_files'  being overwritten.


Solution : 

Install the security patch wget-1689.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the wget-1689 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"wget-1.10.2-15.4", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
