#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27477);
 script_cve_id("CVE-2007-0459", "CVE-2007-0458", "CVE-2007-0457", "CVE-2007-0456");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: wireshark: Version 0.99.5 fixes four vulnerabilities (wireshark-2638)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch wireshark-2638.

Description :

Wireshark 0.99.5 fixes four vulnerabilities:
- CVE-2007-0459 The TCP dissector could hang or crash
- CVE-2007-0458 The HTTP dissector could crash
- CVE-2007-0457 The IEEE 802.11 dissector could crash
- CVE-2007-0456 The LLT dissector could crash


Solution : 

Install the security patch wireshark-2638.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the wireshark-2638 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"wireshark-0.99.5-5.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"wireshark-devel-0.99.5-5.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
