#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29595);
 script_cve_id("CVE-2006-4513");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for wv (wv-2280)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch wv-2280.

Description :

Two integer overflows were found in the Microsoft Word
converter library 'wv', which could potentially be used to
crash programs using this library or to even execute code.

- A LVL Count Integer Overflow Vulnerability was fixed.
- A LFO Count Integer Overflow Vulnerability was fixed.

Both problems have been assigned the Mitre CVE ID
CVE-2006-4513.


Solution : 

Install the security patch wv-2280.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the wv-2280 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"wv-1.0.3-20.5", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
