#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(31115);
 script_cve_id("CVE-2008-0386");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: xdg-utils security update (xdg-utils-4983)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch xdg-utils-4983.

Description :

xdg-open and xdg-email didn't properly check their
arguments. Therefore e.g. URLs passed to those programs
could contain shell code that got executed (CVE-2008-0386).


Solution : 

Install the security patch xdg-utils-4983.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the xdg-utils-4983 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"xdg-utils-1.0.1-9", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"xdg-utils-1.0.1-86.2", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
