#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29792);
 script_cve_id("CVE-2007-5906", "CVE-2007-5907");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: xen security update (xen-4854)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch xen-4854.

Description :

This update fixes various Xen issues.

Two security problems were fixed: CVE-2007-5906: Xen
allowed virtual guest system users to cause a denial of
service (hypervisor crash) by using a debug register (DR7)
to set certain breakpoints.

CVE-2007-5907: Xen 3.1.1 does not prevent modification of
the CR4 TSC from applications, which allows pv guests to
cause a denial of service (crash).

Also the following bugs were fixed: 279062: Timer ISR/1:
Time went backwards 286859: Fix booting from SAN 310279:
Kernel Panic while booting Xen 338486: xen fails to start
when option 'irq= [ <value> ]' is given in domU config


Solution : 

Install the security patch xen-4854.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the xen-4854 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"xen-3.1.0_15042-51.3", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"xen-devel-3.1.0_15042-51.3", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"xen-doc-html-3.1.0_15042-51.3", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"xen-doc-pdf-3.1.0_15042-51.3", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"xen-libs-3.1.0_15042-51.3", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"xen-tools-3.1.0_15042-51.3", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"xen-tools-domU-3.1.0_15042-51.3", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"xen-tools-ioemu-3.1.0_15042-51.3", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
