#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27485);
 script_cve_id("CVE-2006-4799", "CVE-2006-4800");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: xine-lib: Fixed various buffer overflow security problems (xine-lib-2308)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch xine-lib-2308.

Description :

Multiple buffer overflows were fixed in the XINE decoder
libraries, which could be used by attackers to crash
players or potentially execute code.

CVE-2006-4799: Buffer overflow in ffmpeg for xine-lib
before 1.1.2 might allow context-dependent attackers to
execute arbitrary code via a crafted AVI file and 'bad
indexes'.

CVE-2006-4800: Multiple buffer overflows in libavcodec in
ffmpeg before 0.4.9_p20060530 allow remote attackers to
cause a denial of service or possibly execute arbitrary
code via multiple unspecified vectors in (1) dtsdec.c, (2)
vorbis.c, (3) rm.c, (4) sierravmd.c, (5) smacker.c, (6)
tta.c, (7) 4xm.c, (8) alac.c, (9) cook.c, (10) shorten.c,
(11) smacker.c, (12) snow.c, and (13) tta.c.


Solution : 

Install the security patch xine-lib-2308.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the xine-lib-2308 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"xine-lib-1.1.1-24.10", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"xine-lib-32bit-1.1.1-24.10", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"xine-lib-64bit-1.1.1-24.10", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
