#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29600);
 script_cve_id("CVE-2007-0017");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for xine (xine-lib-2505)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch xine-lib-2505.

Description :

This update fixes several format string bugs that can be
exploited remotely
 with user-assistance to execute
arbitrary code. (CVE-2007-0017)


Solution : 

Install the security patch xine-lib-2505.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the xine-lib-2505 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"xine-lib-1.1.1-24.17", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
