#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27493);
 
 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: Securityfix for Xserver crashes when reading PCF fonts. (xorg-x11-server-1914)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch xorg-x11-server-1914.

Description :

This security update fixes crashes in the PCF handling,
which might be used to crash the Xserver using applications
or even to execute  code in them.


Solution : 

Install the security patch xorg-x11-server-1914.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the xorg-x11-server-1914 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"xorg-x11-server-6.9.0-50.20", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
