#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27494);
 script_cve_id("CVE-2006-3739");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: xorg-x11-server: Fix for integer overflow vulnerability (xorg-x11-server-2056)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch xorg-x11-server-2056.

Description :

This update fixes an integer overflow vulnerability when
rendering CID-keyed fonts (CVE-2006-3739/CVE-2006-3740).


Solution : 

Install the security patch xorg-x11-server-2056.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the xorg-x11-server-2056 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"xorg-x11-server-6.9.0-50.24", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
