#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27497);
 script_cve_id("CVE-2007-0104");

 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: This update fixes a vulnerability which occurs while processing a special PDF file. (xpdf-2473)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch xpdf-2473.

Description :

This update fixes a vulnerability which occurs while
processing a
 special PDF file.
 This bug can lead to a
denial-of-service condition, or a memory
 corruption, or to
arbitrary code execution. (CVE-2007-0104)


Solution : 

Install the security patch xpdf-2473.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the xpdf-2473 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"xpdf-3.01-21.6", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"xpdf-3.01-58.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
