#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29611);
 script_cve_id("CVE-2007-1859");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for xscreensaver (xscreensaver-3241)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch xscreensaver-3241.

Description :

xscreensaver could crash under certain circumstances
causing the screen to unlock. That could happen for example
when LDAP is used for authentication and the network
connection gets interrupted for a long time (CVE-2007-1859).


Solution : 

Install the security patch xscreensaver-3241.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the xscreensaver-3241 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"xscreensaver-4.23-20.6", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"xscreensaver-4.23-20.6", release:"SLED10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
