#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(29612);
 script_cve_id("CVE-2006-5601");

 script_version ("$Revision: 1.1 $");

 name["english"] = "SuSE Security Update: Security update for xsupplicant (xsupplicant-2455)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch xsupplicant-2455.

Description :

xsupplicant has been upgraded to version 1.2.8, which
includes
 bugfixes and one security fix:

CVE-2006-5601: A post-authentication stack overflow in the
EAP handling
 could be used by already authenticated
attacker to overflow
 a stackbuffer and so potentially
execute code.


Solution : 

Install the security patch xsupplicant-2455.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the xsupplicant-2455 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"xsupplicant-1.2.8-14.4", release:"SLES10") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
