#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(28180);
 
 script_version ("$Revision: 1.2 $");

 name["english"] = "SuSE Security Update: YaST2: This update fixes a local root vulnerability. (yast2-core-4634)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch yast2-core-4634.

Description :

This update fixes a security bug in yast2-core that allowed
local attackers to provide malicious yast2 modules to yast2
that are executed with root privileges. To trigger this
vulnerability root has to execute yast2 in an untrusted
directory (i.e. /tmp).  Thanks to Stefan Nordhausen for
reporting this to us.


Solution : 

Install the security patch yast2-core-4634.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the yast2-core-4634 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"yast2-core-2.13.23.1-0.1", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"yast2-core-devel-2.13.23.1-0.1", release:"SUSE10.1") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"yast2-core-2.14.5-0.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"yast2-core-devel-2.14.5-0.1", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"yast2-core-2.15.13-0.1", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
if ( rpm_check( reference:"yast2-core-devel-2.15.13-0.1", release:"SUSE10.3") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
