#
# (C) Tenable Network Security
#
# The text description of this plugin is (C) Novell, Inc.
#

if ( ! defined_func("bn_random") ) exit(0);

if(description)
{
 script_id(27505);
 
 script_version ("$Revision: 1.4 $");

 name["english"] = "SuSE Security Update: zypper: Fix for file-handling. (zypper-4443)";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote SuSE system is missing the security patch zypper-4443.

Description :

This update of zypper fixes some security related bugs that
occur while handling files. These bugs can be abused to get
access to log-files for reading and writing as well as
causing denial-of-service conditions.  Thanks to Stefan
Nordhausen for reporting this.


Solution : 

Install the security patch zypper-4443.

Risk factor : 

High";

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the zypper-4443 package";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");
 family["english"] = "SuSE Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/SuSE/rpm-list");
 exit(0);
}

include("rpm.inc");


if ( rpm_check( reference:"zypper-0.6.15-0.4", release:"SUSE10.2") )
{
	security_hole(port:0, extra:rpm_report_get());
	exit(0);
}
