#
# (C) Tenable Network Security
#


  desc["english"] = "
Synopsis :

The remote host is running a web server for Samba administration.

Description :

The remote host is running SWAT, the Samba Web Administration Tool.

The remote SWAT server appears to be running in demo mode.
In demo mode, authentication is disabled and anyone can use SWAT to 
modify Samba's configuration file. Demo mode should not be used on a 
production server.

See also :

http://www.samba.org/samba/docs/man/Samba-HOWTO-Collection/SWAT.html

Solution :

Either disable SWAT or limit access to authorized users and ensure that
it is set up with stunnel to encrypt network traffic. 

Risk factor :

High / CVSS Base Score : 7.5 
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description) {
  script_id(26926);
  script_version("$Revision: 1.1 $");

  name["english"] = "SWAT no authentication (demo mode)";
  script_name(english:name["english"]);

  script_description(english:desc["english"]);
 
  summary["english"] = "Detects a SWAT Server in demo mode";
  script_summary(english:summary["english"]);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Service detection");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");

  script_dependencies("swat_detect.nasl");
  script_require_ports("Services/swat", "Services/www", 901);

  exit(0);
}


port = get_kb_item("SWAT/no_auth");
if (!isnull(port))
  security_hole(port);
