#TRUSTED 7ea2476d8204994e124a52402f7c0fe9926533b5b39eceea153e497f5699b504f4b50e43fbad57f84ed732eb222500a40f12447d63cc40ac7d9fa18f286e616aa74bf07d1df5220d7b5c8d354302a4bf7501b85648321b3ca160f50e42b9faba95fcbbddc328f56ebbe4fc2299dd93f2b43b41e83ee5c40b272afd26ec2151a0475e0c05059e28e1145a70081780a16ebe5f1a7de69b2d5af6f24100286f9df73b8fdfb8aee0dcc0e06f3acb7455aa9aa9e09268ade09293801dfb6916fff02ddcb255dfd919ecb7a21b568bc6896fc39666bd992b608d57c3db93c780f10c84bd5960c6e7e9305d3e0457a81127c598945b09ed739dd9605a411a28890925e8c0a0884a5593c04b9365de13ab2da9059aedcb91a3c9f0a7c0b82a1f550158e387b21c2bc5348b5952042fe3c56cdb5c5bf5f565c786b7a9c7fe5f639562c4ca68809653c0a12f61521884b5bde7dfd3b98ace0b804f06396bffcaa799653d6635272d222bf4f7b012cf6fdf4061786491ecbeb241c90ba9adc74a5601501f49ce8a4e7ee64b6e4cb0fc63cfcc6ed888ed3a627dd1284e720abe2536ca3676be41c0cc3ee59180899f1d66c6212f36b40ba3fd1ad0a3b413175f2e20d7fa8e5c4a2c2768223539ba5b2f2910f6150ffa73f3a5eca9c518b22ab734f016e5ceae05bb2a568271afd197f22e826fa7b08bf80d8e68e952b0c2916a418c5edae8da
# -*- Fundamental -*-
#
# (C) 2002 Michel Arboi <arboi@alussinan.org>
# (C) 2005 Tenable Network Security

OPT_WILL 	= 0xfb;
OPT_WONT 	= 0xfc;
OPT_DO   	= 0xfd;
OPT_DONT 	= 0xfe;

OPT_SUBOPT 	= 0xfa;
OPT_ENDSUBOPT 	= 0xf0;

function get_telnet_banner(port)
{
  local_var sb, banner, soc;
  sb = string("Services/telnet/banner/", port);
  banner = get_kb_item(sb);
  if (banner) return(banner);

  soc = open_sock_tcp(port);
  if(!soc) return (0);
  banner = telnet_negotiate(socket:soc);
  close(soc);
  if(strlen(banner)){
	if ( defined_func("replace_kb_item") )
		replace_kb_item(name: sb, value: str_replace(find:raw_string(0), replace:'', string:banner));
	else
		set_kb_item(name: sb, value: str_replace(find:raw_string(0), replace:'', string:banner));
	}
  return(banner);
}


function telnet_negotiate(socket, pattern)
{
 local_var opt, code, s, counter, counter2, buf, prev, timeout;

 counter = 0;
 timeout = 5;

 while ( TRUE )
 {
  s   = recv(socket:socket, length:1, timeout:timeout);
  timeout = 1;
  if ( !strlen(s) ) break;
  if ( ord(s[0]) != 0xff) {
	 buf += s;
         if ( pattern && egrep(pattern:pattern, string:buf) ) break;
	 }
  else {
   counter ++;
   s  = recv(socket:socket, length:2);

   if ( ord(s[0]) == OPT_DO ) send(socket:socket,data:raw_string(0xff, OPT_WONT) + s[1]);
   else if ( ord(s[0]) == OPT_WILL ) send(socket:socket,data:raw_string(0xff, OPT_DONT) + s[1]);
   else if ( ord(s[0]) == OPT_SUBOPT )
	{
	 # The remote telnet server is autistic :/
	 prev = recv(socket:socket, length:1);
         counter2 = 0;
	 while ( ord(prev) != 0xff && ord(s[0]) != OPT_ENDSUBOPT )
	   {
	    prev = s;
 	    # No timeout - the answer is supposed to be cached
	    s    = recv(socket:socket, length:1, timeout:0);
	    if ( ! strlen(s) ) return buf;
	    counter2++;
	    if ( counter2 >= 100 ) return buf;
	   }
	}
  
   # Not necessary and may introduce endless loops
   #if ( ord(s[0]) == OPT_DONT ) send(socket:socket,data:raw_string(0xff, OPT_WONT) + s[1]);
   #if ( ord(s[0]) == OPT_WONT ) send(socket:socket,data:raw_string(0xff, OPT_DONT) + s[1]);
  }
  if ( counter >= 100 || strlen(buf) >= 4096 ) break;
 }

 
 return buf;
}

function set_telnet_banner(port, banner)
{
  local_var sb;
  sb = string("Services/telnet/banner/", port);
  if ( defined_func("replace_kb_item") )
	replace_kb_item(name: sb, value: str_replace(find:raw_string(0), replace:'', string:banner));
  else
	set_kb_item(name: sb, value: str_replace(find:raw_string(0), replace:'', string:banner));
}


# (C) Tenable Security

function recv_until(socket, pattern)
{
 local_var r, i, l, buf;
 i = 0; l = 0;

#debug_print('recv_until(pattern=', pattern, ')\n');
 while ( TRUE )
 {
  i ++;
  if ( i > 1024*1024 ) return NULL;
  r = recv(socket:socket, length:1);
  if ( strlen(r) == 0 ) break;
  if (r == '\0') continue;	# The shell sometimes sends back very dirty things
  l ++;
  buf += r;
  # Regex size is limited?
  if (l <= 256)
  {
   if ( egrep(pattern:pattern,string:buf) ) return buf;
  }
  else
  {
   if (egrep(pattern:pattern,string:substr(buf, l - 256))) return buf;
  }
 }
#dump(ddata: buf, dtitle: 'telnet');
#debug_print('recv_until(pattern=', pattern, ') = NULL !\n');
#dump(dtitle: 'telnet', ddata: buf);
 return NULL;
}
