#
# (C) Tenable Network Security
#

if(description)
{
 script_id(14729);
 script_cve_id("CVE-2004-0902", "CVE-2004-0903", "CVE-2004-0904");
 script_bugtraq_id(11174, 11171, 11170);
 script_xref(name:"OSVDB", value:"9968");
 script_version("$Revision: 1.11 $");

 name["english"] = "Mozilla/Thunderbird multiple flaws";

 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is using Mozilla and/or Thunderbird, an alternative mail user
agent.

The remote version of this software is vulnerable to several flaws which
may allow an attacker to execute arbitrary code on the remote host.

To exploit this flaw, an attacker would need to send a rogue email
to a victim on the remote host.

Solution : Upgrade to Mozilla 1.7.3 or Thunderbird 0.8 or later.
Risk factor : High";



 script_description(english:desc["english"]);
 
 summary["english"] = "Determines the version of Mozilla";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2004-2007 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 
 script_dependencies("mozilla_org_installed.nasl");
 script_require_keys("Mozilla/Thunderbird/Version");

 exit(0);
}


include("misc_func.inc");


ver = read_version_in_kb("Mozilla/Version");
if (!isnull(ver))
{
  if (
    ver[0] < 1 ||
    (
      ver[0] == 1 &&
      (
        ver[1] < 7 ||
        (ver[1] == 7 && ver[2] < 3)
      )
    )
  )  security_hole(get_kb_item("SMB/transport"));
}

ver = read_version_in_kb("Mozilla/Thunderbird/Version");
if (!isnull(ver))
{
  if (ver[0] == 0 && ver[1] < 8)
    security_hole(get_kb_item("SMB/transport"));
}
