#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25199);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-2621");
  script_bugtraq_id(23912);

  script_name(english:"Thyme eid Parameter SQL Injection Vulnerability");
  script_summary(english:"Tries to generate a SQL error");

  desc = "
Synopsis :

The remote web server contains a PHP script that is prone to a SQL
injection attack. 

Description :

The remote host is running Thyme, a web-based calendar. 

The version of Thyme installed on the remote host fails to properly
sanitize user-supplied input to the 'eid' parameter of the
'event_view.php' script before using it to build a database query. 
Regardless of PHP's 'magic_quotes_gpc' setting, an unauthenticated
remote attacker can leverage this issue to launch SQL injection
attacks against the affected application, leading to discovery of
sensitive information, attacks against the underlying database, and
the like. 

See also :

http://www.milw0rm.com/exploits/3895
http://www.extrosoft.com/?option=com_content&task=view&id=171

Solution :

Update Thyme as described in the vendor advisory referenced above.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through various directories.
if (thorough_tests) dirs = make_list("/thyme", "/events", "/schedule", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to exploit the flaw to manipulate the main text.
  magic = rand();
  exploit = string("34 UNION SELECT ", magic);

  req = http_get(
    item:string(
      dir, "/event_view.php?",
      "eid=", urlencode(str:exploit)
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if...
  if (
    # We saw an attachment with our magic or...
    string("/download_attachment.php?aid=", magic, "'") >< res ||
    # We saw an error from PostgreSQL.
    string('class.pgsql.php :: query() :: ERROR:  invalid input syntax for type bigint: "', exploit) >< res
  )
  {
    security_hole(port);
    exit(0);
  }
}
