#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote Windows host has a program that is affected by multiple
issues. 

Description :

According to its version, the installation of Timbuktu Pro on the
remote host reportedly is affected by three buffer overflows that can
be exploited without authentication to crash the service or execute
arbitrary code on the affected host with SYSTEM privileges. 

In addition, the application also may allow for creation or deletion
of arbitrary files with SYSTEM privileges on the affected host. 

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=589
http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=590
http://archives.neohapsis.com/archives/bugtraq/2007-08/0425.html
http://archives.neohapsis.com/archives/bugtraq/2007-08/0428.html
http://www.nessus.org/u?f33df19c

Solution :

Upgrade to Timbuktu Pro for Windows version 8.6.5 or later. 

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(25954);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-4220", "CVE-2007-4221");
  script_bugtraq_id(25453, 25454);
  script_xref(name:"OSVDB", value:"40121");
  script_xref(name:"OSVDB", value:"40123");
  script_xref(name:"OSVDB", value:"40124");
  script_xref(name:"OSVDB", value:"40125");

  script_name(english:"Timbuktu Pro < 8.6.5 Multiple Vulnerabilities");
  script_summary(english:"Checks version of tb2pro.exe");

  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("smb_func.inc");


# Connect to the appropriate share.
if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);
name    =  kb_smb_name();
port    =  kb_smb_transport();
if (!get_port_state(port)) exit(0);
login   =  kb_smb_login();
pass    =  kb_smb_password();
domain  =  kb_smb_domain();

soc = open_sock_tcp(port);
if (!soc) exit(0);

session_init(socket:soc, hostname:name);
rc = NetUseAdd(login:login, password:pass, domain:domain, share:"IPC$");
if (rc != 1)
{
  NetUseDel();
  exit(0);
}


# Connect to remote registry.
hklm = RegConnectRegistry(hkey:HKEY_LOCAL_MACHINE);
if (isnull(hklm))
{
  NetUseDel();
  exit(0);
}


# Check whether it's installed.
path = NULL;

key = "SOFTWARE\Netopia\Timbuktu Pro";
key_h = RegOpenKey(handle:hklm, key:key, mode:MAXIMUM_ALLOWED);
if (!isnull(key_h))
{
  value = RegQueryValue(handle:key_h, item:"InstallPath");
  if (!isnull(value))
  {
    path = value[1];
    path = ereg_replace(pattern:"^(.+)\\$", replace:"\1", string:path);
  }

  RegCloseKey(handle:key_h);
}
RegCloseKey(handle:hklm);
if (isnull(path))
{
  NetUseDel();
  exit(0);
}


# Check the version of the main exe.
share = ereg_replace(pattern:"^([A-Za-z]):.*", replace:"\1$", string:path);
exe =  ereg_replace(pattern:"^[A-Za-z]:(.*)", replace:"\1\tb2pro.exe", string:path);
NetUseDel(close:FALSE);

rc = NetUseAdd(login:login, password:pass, domain:domain, share:share);
if (rc != 1)
{
  NetUseDel();
  exit(0);
}

fh = CreateFile(
  file:exe,
  desired_access:GENERIC_READ,
  file_attributes:FILE_ATTRIBUTE_NORMAL,
  share_mode:FILE_SHARE_READ,
  create_disposition:OPEN_EXISTING
);
ver = NULL;
if (!isnull(fh))
{
  ver = GetFileVersion(handle:fh);
  CloseFile(handle:fh);
}

# Check the version number.
if (!isnull(ver))
{
  fix = split("8.6.5.1373", sep:'.', keep:FALSE);
  for (i=0; i<max_index(fix); i++)
    fix[i] = int(fix[i]);

  for (i=0; i<max_index(ver); i++)
    if ((ver[i] < fix[i]))
    {
      version = string(ver[0], ".", ver[1], ".", ver[2]);
      report = desc + string(
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Version ", version, " of Timbuktu Pro is installed under :\n",
        "\n",
        "  ", path
      );
      security_hole(port:port, data:report);
      break;
    }
    else if (ver[i] > fix[i])
      break;
}


# Clean up.
NetUseDel();
