#
# This script was written by Alexander Strouk
#
# See the Nessus Scripts License for details
#
#
if(description)
{
 script_id(10491); 
 script_bugtraq_id(1578);
 script_version ("$Revision: 1.23 $");
 script_cve_id("CVE-2000-0778");
 name["english"] = "ASP/ASA source using Microsoft Translate f: bug";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote web server is affected by an information disclosure flaw. 

Description :

There is a serious vulnerability in Windows 2000 (unpatched by SP1)
that allows an attacker to view ASP/ASA source code instead of a
processed file.  SP source code can contain sensitive information such
as usernames and passwords for ODBC connections. 

See also :

http://www.microsoft.com/technet/security/bulletin/MS00-058.asp

Solution : 

Install Windows 2000 Service Pack 1 or later. 

Risk factor : 

Low / CVSS Base Score : 1
(AV:R/AC:L/Au:R/C:P/A:N/I:N/B:N)";

 script_description(english:desc["english"]);
 summary["english"] = "downloads the source of IIS scripts such as ASA,ASP";
 script_summary(english:summary["english"]);
 script_category(ACT_GATHER_INFO);
 copyright="This script is Copyright (C) 2000 Alexander Strouk";
 script_copyright(english:copyright);
 script_family(english:"CGI abuses");
 script_dependencie("find_service1.nasl", "no404.nasl", "http_version.nasl", "www_fingerprinting_hmap.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if  (! port || get_kb_item("Services/www/" + port + "/embedded") ) exit(0);

sig = get_kb_item("www/hmap/" + port + "/description");
if ( ! sig ) sig = get_http_banner(port:port);
if ( sig && "IIS" >!< sig ) exit(0);
if(!get_port_state(port)) exit(0);
req = string("GET /global.asa HTTP/1.0\r\n\r\n");
r = http_keepalive_send_recv(port:port, data:req);
if ( r !~ "HTTP/[0-9.]+ 500 " ) exit(0);
req = string("GET /global.asa\\ HTTP/1.0\r\nTranslate: f\r\n\r\n");
r = http_keepalive_send_recv(port:port, data:req);
if ( r =~ "HTTP/[0-9.]+ 404" )
{
 req = string("GET /global.asa HTTP/1.0\r\nTranslate: f\r\n\r\n");
 r = http_keepalive_send_recv(data:req, port:port);
 if ( r =~ "HTTP/[0-9.]+ 403 " ) { 
	security_note(port);
	set_kb_item(name:"Services/www/ms00-058", value:"missing");
	}
 else 
	set_kb_item(name:"Services/www/ms00-058", value:"installed");
}

