#
# (C) Tenable Network Security
#
# 

  desc = "
Synopsis :

The remote host is running an antivirus.

Description :

The remote host is running Trend Micro ServerProtect for Windows /
Netware, an AntiVirus / AntiSpyware for Windows and Netware servers. 

Risk factor :

None";

if (description)
{
 script_id(24679);
 script_version("$Revision: 1.2 $");

 name["english"] = "Trend Micro ServerProtect Detection";
 script_name(english:name["english"]);
 
 script_description(english:desc);
 
 summary["english"] = "Checks for ServerProtect version";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 script_family(english:"Service detection");

 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc");

 script_require_ports(5168);
 exit(0);
}


include ('smb_func.inc');

 
port = 5168;
if ( ! get_port_state(port) )
  exit(0);

soc = open_sock_tcp (port);
if (!soc)
  exit (0);

ret = dce_rpc_bind(cid:session_get_cid(), uuid:"25288888-bd5b-11d1-9d53-0080c83a5c2c", vers:1);
send (socket:soc, data:ret);
resp = recv (socket:soc, length:4096);

if (!resp)
{
 close (soc);
 exit (0); 
}

ret = dce_rpc_parse_bind_ack (data:resp);
if (isnull (ret) || (ret != 0))
{
 close (soc);
 exit (0);
}

data = 
	raw_dword(d:0x000A0006)  +
	raw_dword(d:0) +
	raw_dword(d:0) +
	raw_dword(d:0x300);


ret = dce_rpc_request (code:0x00, data:data);
send (socket:soc, data:ret);
resp = recv (socket:soc, length:4096);

resp = dce_rpc_parse_response (data:resp);
if (strlen(resp) != 0x308)
  exit (0);

pattern = get_string(blob:resp, pos:8, _type:0);
version = get_string(blob:resp, pos:28, _type:0);
engine = get_string(blob:resp, pos:56, _type:0);
path = get_string(blob:resp, pos:76, _type:0);

set_kb_item(name:"Antivirus/TrendMicro/ServerProtect", value:version);

ret = string (
	"Pattern : ", pattern, "\n",
	"Version : ", version, "\n",
	"Engine  : ", engine, "\n",
	"Path    : ", path, "\n"
	);

report = string(
	desc,
	"\n\n",
	"Plugin output :\n",
	"\n",
	ret,"\n"
  	);

security_note(port:port, data:report);
