#
# (C) Tenable Network Security
#

if(description)
{
 script_id(18405);
 script_version("$Revision: 1.8 $");
 script_cve_id("CVE-2005-1794");
 script_bugtraq_id(13818);
 script_xref(name:"OSVDB", value:"17131");

 name["english"] = "Microsoft Windows Remote Desktop Protocol Server Private Key Disclosure Vulnerability";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

It may be possible to get access to the remote host.

Description :

The remote version of Remote Desktop Protocol Server (Terminal Service) is
vulnerable to a man in the middle attack.

An attacker may exploit this flaw to decrypt communications between client
and server and obtain sensitive information (passwords, ...).


Solution :

Force the use of SSL as a transport layer for this service.

See also :

http://www.oxid.it/downloads/rdp-gbu.pdf
http://www.nessus.org/u?c544b1fa

Risk factor :

Medium / CVSS Base Score : 6 
(AV:R/AC:H/Au:NR/C:P/A:P/I:P/B:N)";

 script_description(english:desc["english"]);
 
 summary["english"] = "Determines if the remote terminal service is vulnerable to MIM attacks";

 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005-2006 Tenable Network Security");
 family["english"] = "Windows";
 script_family(english:family["english"]);
 script_dependencies("windows_terminal_services.nasl");
 script_require_ports(3389);
 exit(0);
}


function reverse (s)
{
 local_var tmp, i;

 tmp = NULL;

 for (i=strlen(s)-1; i>=0;i--)
    tmp += s[i];

 return tmp;
}


port = get_kb_item("Services/msrdp");
if (!port || !get_port_state(port)) exit (0);

soc = open_sock_tcp (port);
if (!soc) exit (0);

# function iso_send_connection_request [iso.c]

req = raw_string ( 0x03, 0x00, 0x00, 0x24, 0x1F, 0xE0, 0x00, 0x00, 0x00, 0x00,
                   0x00, 0x43, 0x6F, 0x6F, 0x6B, 0x69, 0x65, 0x3A, 0x20, 0x6D,
                   0x73, 0x74, 0x73, 0x68, 0x61, 0x73, 0x68, 0x3D, 0x6E, 0x65,
                   0x73, 0x73, 0x75, 0x73, 0x0D, 0x0A );

resp = raw_string (0x03, 0x00, 0x00, 0x0B, 0x06, 0xD0, 0x00, 0x00, 0x12, 0x34, 0x00);

send (socket:soc, data:req);
buf = recv (socket:soc, length:11);

if (resp >!< buf)
  exit (0);


# function sec_out_mcs_data [secure.c]
req = raw_string (
0x03, 0x00, 0x01, 0x96,  0x02, 0xF0, 0x80, 0x7F,  0x65, 0x82, 0x01, 0x8A,  0x04, 0x01, 0x01, 0x04,  0x01, 0x01, 0x01, 0x01,
0xFF, 0x30, 0x20, 0x02,  0x02, 0x00, 0x22, 0x02,  0x02, 0x00, 0x02, 0x02,  0x02, 0x00, 0x00, 0x02,  0x02, 0x00, 0x01, 0x02,
0x02, 0x00, 0x00, 0x02,  0x02, 0x00, 0x01, 0x02,  0x02, 0xFF, 0xFF, 0x02,  0x02, 0x00, 0x02, 0x30,  0x20, 0x02, 0x02, 0x00,
0x01, 0x02, 0x02, 0x00,  0x01, 0x02, 0x02, 0x00,  0x01, 0x02, 0x02, 0x00,  0x01, 0x02, 0x02, 0x00,  0x00, 0x02, 0x02, 0x00,
0x01, 0x02, 0x02, 0x04,  0x20, 0x02, 0x02, 0x00,  0x02, 0x30, 0x20, 0x02,  0x02, 0xFF, 0xFF, 0x02,  0x02, 0xFC, 0x17, 0x02,
0x02, 0xFF, 0xFF, 0x02,  0x02, 0x00, 0x01, 0x02,  0x02, 0x00, 0x00, 0x02,  0x02, 0x00, 0x01, 0x02,  0x02, 0xFF, 0xFF, 0x02,
0x02, 0x00, 0x02, 0x04,  0x82, 0x01, 0x17, 0x00,  0x05, 0x00, 0x14, 0x7C,  0x00, 0x01, 0x81, 0x0E,  0x00, 0x08, 0x00, 0x10,
0x00, 0x01, 0xC0, 0x00,  0x44, 0x75, 0x63, 0x61,  0x81, 0x00, 0x01, 0xC0,  0xD4, 0x00, 0x04, 0x00,  0x08, 0x00, 0x00, 0x04,
0x00, 0x03, 0x01, 0xCA,  0x03, 0xAA, 0x09, 0x04,  0x00, 0x00, 0x28, 0x0A,  0x00, 0x00, 0x74, 0x00,  0x65, 0x00, 0x6e, 0x00,
0x61, 0x00, 0x62, 0x00,  0x6C, 0x00, 0x65, 0x00,  0x73, 0x00, 0x65, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x04, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x0C, 0x00,  0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x01, 0xCA,  0x01, 0x00, 0x00, 0x00,  0x00, 0x00, 0x08, 0x00,  0x07, 0x00, 0x01, 0x00,  0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x04, 0xC0,  0x0C, 0x00, 0x09, 0x00,  0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x02, 0xC0,  0x0C, 0x00, 0x03, 0x00,
0x00, 0x00, 0x00, 0x00,  0x00, 0x00, 0x03, 0xC0,  0x14, 0x00, 0x01, 0x00,  0x00, 0x00, 0x63, 0x6C,  0x69, 0x70, 0x72, 0x64,
0x72, 0x00, 0xC0, 0xA0,  0x00, 0x00
);

send (socket:soc, data:req);
buf = recv (socket:soc, length:4096);


if ("RSA1" >!< buf)
  exit (0);

blob = strstr (buf, "RSA1");

# extract key_blob
first = strlen(buf) - strlen(blob) - 16;
end = first + 107;

if (strlen(buf) < end)
  exit (0);

public_key = substr (buf, first, end);

# extract sig
sig = substr (buf, end+5, strlen(buf)-9);
sig = reverse(s:sig);

e = raw_string ( 0x5B,0x7B,0x88,0xC0 );
e = reverse (s:e);

n = raw_string ( 0x3D,0x3A,0x5E,0xBD,0x72,0x43,0x3E,0xC9,0x4D,0xBB,0xC1,0x1E,0x4A,0xBA,0x5F,0xCB, 
                 0x3E,0x88,0x20,0x87,0xEF,0xF5,0xC1,0xE2,0xD7,0xB7,0x6B,0x9A,0xF2,0x52,0x45,0x95, 
                 0xCE,0x63,0x65,0x6B,0x58,0x3A,0xFE,0xEF,0x7C,0xE7,0xBF,0xFE,0x3D,0xF6,0x5C,0x7D, 
                 0x6C,0x5E,0x06,0x09,0x1A,0xF5,0x61,0xBB,0x20,0x93,0x09,0x5F,0x05,0x6D,0xEA,0x87 );
n = reverse (s:n);

hash = MD5 (public_key);

decrypted = rsa_public_decrypt(sig:sig,e:e,n:n);
decrypted = reverse (s:decrypted);
if (!decrypted)
  exit (1);

if (hash >< decrypted)
  security_warning(port);
