# This script was automatically generated from the 260-1 Ubuntu Security Notice
# It is released under the Nessus Script Licence.
# Ubuntu Security Notices are (C) 2005 Canonical, Inc.
# USN2nasl Convertor is (C) 2005 Michel Arboi
# See http://www.ubuntulinux.org/usn/
# Ubuntu(R) is a registered trademark of Canonical, Inc.

if (! defined_func("bn_random")) exit(0);
desc = '
Synopsis :

These remote packages are missing security patches :
- cpp-3.3 
- cpp-3.3-doc 
- cpp-3.4 
- cpp-3.4-doc 
- fastjar 
- fixincludes 
- flex 
- flex-doc 
- g++-3.3 
- g++-3.4 
- g77-3.3 
- g77-3.3-doc 
- g77-3.4 
- g77-3.4-doc 
- gcc-3.3 
- gcc-3.3-base 
- gcc-3.3-doc 
- gcc-3.4 
- gcc-3.4-base 
- gcc-3.4-doc 
- gcj-3.3 
- gcj-3.4 
- gij-3.3 
- gij-3.4 
- gnat-3.3 
- gnat-3.3-doc 
- gnat-3.4 
- gnat-3.4-doc 
- gobjc-3.3 
- gobjc-3.4 
- gpc-2.1-3.3 
- gpc-2.1-3.3-doc 
- gpc-2.1-3.4 
- gpc-2.1-3.4-doc 
- lib32g
[...]

Description :

Chris Moore discovered a buffer overflow in a particular class of
lexicographical scanners generated by flex. This could be exploited to
execute arbitrary code by processing specially crafted user-defined
input to an application that uses a flex scanner for parsing.

This flaw particularly affects gpc, the GNU Pascal Compiler. A
potentially remote attacker could exploit this by tricking an user or
automated system into compiling a specially crafted Pascal source code
file.

Please note that gpc is not officially supported in Ubuntu (it is in
the \'universe\' component of the archive). However, this affects you if
you use a customized version built from the gcc-3.3 or gcc-3.4 source
package (which is supported).

Solution :

Upgrade to : 
- cpp-3.3-3.3.5-8ubuntu2.1 (Ubuntu 5.04)
- cpp-3.3-doc-3.3.5-8ubuntu2.1 (Ubuntu 5.04)
- cpp-3.4-3.4.4-6ubuntu8.1 (Ubuntu 5.10)
- cpp-3.4-doc-3.4.4-6ubuntu8.1 (Ubuntu 5.10)
- fastjar-3.4.2-2ubuntu1.1 (Ubuntu 4.10)
- fixincludes-3.3.4-9ubuntu5.1 (Ubuntu 4.10)
- flex-2.5.31-31ubuntu0.5.10.1 (Ubuntu 5.10)
- flex-doc-2.5.31-31ubuntu0.5.10.1 (Ubuntu 5.10)
- g++-3.3-3.3.5-8ubuntu2.1 (Ubuntu 5.04)
- g++-3.4-3.4.4-6ubuntu8.1 (Ubuntu 5.10)
- g77-3.3-3.3.5-8ubuntu2.1 (Ubuntu 5.04)
- g77-3.3-doc-3.3.5-8u
[...]


Risk factor : High
';

if (description) {
script_id(21072);
script_version("$Revision: 1.2 $");
script_copyright("Ubuntu Security Notice (C) 2005 Canonical, Inc. / NASL script (C) 2005 Michel Arboi <mikhail@nessus.org>");
script_category(ACT_GATHER_INFO);
script_family(english: "Ubuntu Local Security Checks");
script_dependencies("ssh_get_info.nasl");
script_require_keys("Host/Ubuntu", "Host/Ubuntu/release", "Host/Debian/dpkg-l");
script_description(english: desc);

script_xref(name: "USN", value: "260-1");
script_summary(english:"flex vulnerability");
script_name(english:"USN260-1 : flex vulnerability");
script_cve_id("CVE-2006-0459");
exit(0);
}

include('ubuntu.inc');

found = ubuntu_check(osver: "5.04", pkgname: "cpp-3.3", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package cpp-3.3-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to cpp-3.3-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "cpp-3.3-doc", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package cpp-3.3-doc-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to cpp-3.3-doc-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "cpp-3.4", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package cpp-3.4-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to cpp-3.4-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "cpp-3.4-doc", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package cpp-3.4-doc-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to cpp-3.4-doc-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "4.10", pkgname: "fastjar", pkgver: "3.4.2-2ubuntu1.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package fastjar-',found,' is vulnerable in Ubuntu 4.10
Upgrade it to fastjar-3.4.2-2ubuntu1.1
');
}
found = ubuntu_check(osver: "4.10", pkgname: "fixincludes", pkgver: "3.3.4-9ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package fixincludes-',found,' is vulnerable in Ubuntu 4.10
Upgrade it to fixincludes-3.3.4-9ubuntu5.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "flex", pkgver: "2.5.31-31ubuntu0.5.10.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package flex-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to flex-2.5.31-31ubuntu0.5.10.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "flex-doc", pkgver: "2.5.31-31ubuntu0.5.10.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package flex-doc-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to flex-doc-2.5.31-31ubuntu0.5.10.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "g++-3.3", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package g++-3.3-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to g++-3.3-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "g++-3.4", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package g++-3.4-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to g++-3.4-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "g77-3.3", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package g77-3.3-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to g77-3.3-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "g77-3.3-doc", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package g77-3.3-doc-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to g77-3.3-doc-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "g77-3.4", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package g77-3.4-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to g77-3.4-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "g77-3.4-doc", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package g77-3.4-doc-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to g77-3.4-doc-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "gcc-3.3", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gcc-3.3-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to gcc-3.3-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "gcc-3.3-base", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gcc-3.3-base-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to gcc-3.3-base-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "gcc-3.3-doc", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gcc-3.3-doc-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to gcc-3.3-doc-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "gcc-3.4", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gcc-3.4-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to gcc-3.4-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "gcc-3.4-base", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gcc-3.4-base-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to gcc-3.4-base-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "gcc-3.4-doc", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gcc-3.4-doc-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to gcc-3.4-doc-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "gcj-3.3", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gcj-3.3-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to gcj-3.3-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "gcj-3.4", pkgver: "3.4.3-9ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gcj-3.4-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to gcj-3.4-3.4.3-9ubuntu4.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "gij-3.3", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gij-3.3-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to gij-3.3-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "gij-3.4", pkgver: "3.4.3-9ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gij-3.4-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to gij-3.4-3.4.3-9ubuntu4.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "gnat-3.3", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gnat-3.3-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to gnat-3.3-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "gnat-3.3-doc", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gnat-3.3-doc-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to gnat-3.3-doc-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "gnat-3.4", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gnat-3.4-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to gnat-3.4-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "gnat-3.4-doc", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gnat-3.4-doc-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to gnat-3.4-doc-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "gobjc-3.3", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gobjc-3.3-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to gobjc-3.3-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "gobjc-3.4", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gobjc-3.4-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to gobjc-3.4-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "gpc-2.1-3.3", pkgver: "3.3.5.20040516-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gpc-2.1-3.3-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to gpc-2.1-3.3-3.3.5.20040516-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "gpc-2.1-3.3-doc", pkgver: "3.3.5.20040516-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gpc-2.1-3.3-doc-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to gpc-2.1-3.3-doc-3.3.5.20040516-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "gpc-2.1-3.4", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gpc-2.1-3.4-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to gpc-2.1-3.4-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "gpc-2.1-3.4-doc", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package gpc-2.1-3.4-doc-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to gpc-2.1-3.4-doc-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "lib32g2c0", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package lib32g2c0-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to lib32g2c0-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "4.10", pkgname: "lib32gcc1", pkgver: "3.4.2-2ubuntu1.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package lib32gcc1-',found,' is vulnerable in Ubuntu 4.10
Upgrade it to lib32gcc1-3.4.2-2ubuntu1.1
');
}
found = ubuntu_check(osver: "4.10", pkgname: "lib32stdc++5", pkgver: "3.3.4-9ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package lib32stdc++5-',found,' is vulnerable in Ubuntu 4.10
Upgrade it to lib32stdc++5-3.3.4-9ubuntu5.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "lib32stdc++6-0", pkgver: "3.4.3-9ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package lib32stdc++6-0-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to lib32stdc++6-0-3.4.3-9ubuntu4.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "lib64g2c0", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package lib64g2c0-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to lib64g2c0-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "4.10", pkgname: "lib64gcc1", pkgver: "3.4.2-2ubuntu1.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package lib64gcc1-',found,' is vulnerable in Ubuntu 4.10
Upgrade it to lib64gcc1-3.4.2-2ubuntu1.1
');
}
found = ubuntu_check(osver: "4.10", pkgname: "lib64stdc++6", pkgver: "3.4.2-2ubuntu1.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package lib64stdc++6-',found,' is vulnerable in Ubuntu 4.10
Upgrade it to lib64stdc++6-3.4.2-2ubuntu1.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libffi2", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libffi2-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libffi2-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libffi2-dev", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libffi2-dev-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libffi2-dev-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libffi3", pkgver: "3.4.3-9ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libffi3-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libffi3-3.4.3-9ubuntu4.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libffi3-dev", pkgver: "3.4.3-9ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libffi3-dev-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libffi3-dev-3.4.3-9ubuntu4.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "libg2c0", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libg2c0-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to libg2c0-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "libg2c0-dev", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libg2c0-dev-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to libg2c0-dev-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "4.10", pkgname: "libgcc1", pkgver: "3.4.2-2ubuntu1.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libgcc1-',found,' is vulnerable in Ubuntu 4.10
Upgrade it to libgcc1-3.4.2-2ubuntu1.1
');
}
found = ubuntu_check(osver: "4.10", pkgname: "libgcj-common", pkgver: "3.3.4-9ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libgcj-common-',found,' is vulnerable in Ubuntu 4.10
Upgrade it to libgcj-common-3.3.4-9ubuntu5.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libgcj4", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libgcj4-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libgcj4-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libgcj4-awt", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libgcj4-awt-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libgcj4-awt-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libgcj4-common", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libgcj4-common-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libgcj4-common-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libgcj4-dev", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libgcj4-dev-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libgcj4-dev-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libgcj5", pkgver: "3.4.3-9ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libgcj5-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libgcj5-3.4.3-9ubuntu4.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libgcj5-awt", pkgver: "3.4.3-9ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libgcj5-awt-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libgcj5-awt-3.4.3-9ubuntu4.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libgcj5-common", pkgver: "3.4.3-9ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libgcj5-common-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libgcj5-common-3.4.3-9ubuntu4.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libgcj5-dev", pkgver: "3.4.3-9ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libgcj5-dev-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libgcj5-dev-3.4.3-9ubuntu4.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "libgnat-3.4", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libgnat-3.4-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to libgnat-3.4-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "4.10", pkgname: "libobjc1", pkgver: "3.3.4-9ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libobjc1-',found,' is vulnerable in Ubuntu 4.10
Upgrade it to libobjc1-3.3.4-9ubuntu5.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libstdc++5", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libstdc++5-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libstdc++5-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libstdc++5-3.3-dbg", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libstdc++5-3.3-dbg-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libstdc++5-3.3-dbg-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libstdc++5-3.3-dev", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libstdc++5-3.3-dev-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libstdc++5-3.3-dev-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libstdc++5-3.3-doc", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libstdc++5-3.3-doc-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libstdc++5-3.3-doc-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libstdc++5-3.3-pic", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libstdc++5-3.3-pic-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libstdc++5-3.3-pic-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "4.10", pkgname: "libstdc++6", pkgver: "3.4.2-2ubuntu1.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libstdc++6-',found,' is vulnerable in Ubuntu 4.10
Upgrade it to libstdc++6-3.4.2-2ubuntu1.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libstdc++6-0", pkgver: "3.4.3-9ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libstdc++6-0-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libstdc++6-0-3.4.3-9ubuntu4.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libstdc++6-0-dbg", pkgver: "3.4.3-9ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libstdc++6-0-dbg-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libstdc++6-0-dbg-3.4.3-9ubuntu4.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libstdc++6-0-dev", pkgver: "3.4.3-9ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libstdc++6-0-dev-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libstdc++6-0-dev-3.4.3-9ubuntu4.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "libstdc++6-0-pic", pkgver: "3.4.3-9ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libstdc++6-0-pic-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to libstdc++6-0-pic-3.4.3-9ubuntu4.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "libstdc++6-dbg", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libstdc++6-dbg-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to libstdc++6-dbg-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "libstdc++6-dev", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libstdc++6-dev-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to libstdc++6-dev-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "libstdc++6-doc", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libstdc++6-doc-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to libstdc++6-doc-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "5.10", pkgname: "libstdc++6-pic", pkgver: "3.4.4-6ubuntu8.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package libstdc++6-pic-',found,' is vulnerable in Ubuntu 5.10
Upgrade it to libstdc++6-pic-3.4.4-6ubuntu8.1
');
}
found = ubuntu_check(osver: "4.10", pkgname: "protoize", pkgver: "3.3.4-9ubuntu5.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package protoize-',found,' is vulnerable in Ubuntu 4.10
Upgrade it to protoize-3.3.4-9ubuntu5.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "treelang-3.3", pkgver: "3.3.5-8ubuntu2.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package treelang-3.3-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to treelang-3.3-3.3.5-8ubuntu2.1
');
}
found = ubuntu_check(osver: "5.04", pkgname: "treelang-3.4", pkgver: "3.4.3-9ubuntu4.1");
if (! isnull(found)) {
w++;
desc = strcat(desc, '
The package treelang-3.4-',found,' is vulnerable in Ubuntu 5.04
Upgrade it to treelang-3.4-3.4.3-9ubuntu4.1
');
}

if (w) { security_hole(port: 0, data: desc); }
